﻿#target captivate-90
// Copyright © 2007. Adobe Systems Incorporated. All Rights Reserved.
//
// ADOBE SYSTEMS INCORPORATED
// Copyright 2005 Adobe Systems Incorporated 
// All Rights Reserved
//
// NOTICE: Adobe permits you to use, modify, and distribute 
// this file in accordance with the terms of the Adobe license 
// agreement accompanying it. If you have received this file 
// from a source other than Adobe, then your use, modification, 
// or distribution of it requires the prior written permission 
// of Adobe.
//
//------------------------------------------------------------------------------

/*
@@@START_XML@@@
<?xml version="1.0" encoding="UTF-8"?>
<ScriptInfo xmlns:dc="http://purl.org/dc/elements/1.1/" xml:lang="en_US">
     <dc:title>Adobe Captivate</dc:title>
     <dc:description>This script enables other applications to communicate with Adobe Captivate.</dc:description>
</ScriptInfo>
<ScriptInfo xmlns:dc="http://purl.org/dc/elements/1.1/" xml:lang="fr_FR">
     <dc:title>Adobe Captivate</dc:title>
     <dc:description>Ce script permet à d'autres applications de communiquer avec Adobe Captivate.</dc:description>
</ScriptInfo>
<ScriptInfo xmlns:dc="http://purl.org/dc/elements/1.1/" xml:lang="ja_JP">
     <dc:title>Adobe Captivate</dc:title>
     <dc:description>このスクリプトは、他のアプリケーションと Adobe Captivate との通信を有効にします。</dc:description>
</ScriptInfo>
<ScriptInfo xmlns:dc="http://purl.org/dc/elements/1.1/" xml:lang="de_DE">
     <dc:title>Adobe Captivate</dc:title>
     <dc:description>Mithilfe dieses Skripts können andere Anwendungen mit Adobe Captivate kommunizieren.</dc:description>
</ScriptInfo>
<ScriptInfo xmlns:dc="http://purl.org/dc/elements/1.1/" xml:lang="it_IT">
     <dc:title>Adobe Captivate</dc:title>
     <dc:description>Questo script consente ad altre applicazioni di comunicare con Adobe Captivate.</dc:description>
</ScriptInfo>
<ScriptInfo xmlns:dc="http://purl.org/dc/elements/1.1/" xml:lang="es_ES">
     <dc:title>Adobe Captivate</dc:title>
     <dc:description>Este script posibilita que otras aplicaciones se comuniquen con Adobe Captivate.</dc:description>
</ScriptInfo>
<ScriptInfo xmlns:dc="http://purl.org/dc/elements/1.1/" xml:lang="nl_NL">
     <dc:title>Adobe Captivate</dc:title>
     <dc:description>Dit script laat andere toepassingen toe te communiceren met Adobe Captivate.</dc:description>
</ScriptInfo>
<ScriptInfo xmlns:dc="http://purl.org/dc/elements/1.1/" xml:lang="pt_BR">
     <dc:title>Adobe Captivate</dc:title>
     <dc:description>Este script permite que outros aplicativos se comuniquem com o Adobe Captivate.</dc:description>
</ScriptInfo>
<ScriptInfo xmlns:dc="http://purl.org/dc/elements/1.1/" xml:lang="nb_NO">
     <dc:title>Adobe Captivate</dc:title>
     <dc:description>Skriptet gjør at andre programmer kan kommunisere med Adobe Captivate.</dc:description>
</ScriptInfo>
<ScriptInfo xmlns:dc="http://purl.org/dc/elements/1.1/" xml:lang="da_DK">
     <dc:title>Adobe Captivate</dc:title>
     <dc:description>Dette script betyder, at andre programmer kan kommunikere med Adobe Captivate.</dc:description>
</ScriptInfo>
<ScriptInfo xmlns:dc="http://purl.org/dc/elements/1.1/" xml:lang="fi_FL">
     <dc:title>Adobe Captivate</dc:title>
     <dc:description>Tämän komentosarjan avulla muut sovellukset ja Adobe Captivate voivat kommunikoida keskenään.</dc:description>
</ScriptInfo>
<ScriptInfo xmlns:dc="http://purl.org/dc/elements/1.1/" xml:lang="sv_SE">
     <dc:title>Adobe Captivate</dc:title>
     <dc:description>Det här skriptet gör det möjligt för andra program att kommunicera med Adobe Captivate.</dc:description>
</ScriptInfo>
<ScriptInfo xmlns:dc="http://purl.org/dc/elements/1.1/" xml:lang="zh_TW">
     <dc:title>Adobe Captivate</dc:title>
     <dc:description>"此指令碼能讓其他應用程式與 Adobe Captivate 進行通訊。</dc:description>
</ScriptInfo>
<ScriptInfo xmlns:dc="http://purl.org/dc/elements/1.1/" xml:lang="zh_CN">
     <dc:title>Adobe Captivate</dc:title>
     <dc:description>"此脚本使其它应用程序能够与 Adobe Captivate 进行通信</dc:description>
</ScriptInfo>
<ScriptInfo xmlns:dc="http://purl.org/dc/elements/1.1/" xml:lang="ko_KR">
     <dc:title>Adobe Captivate</dc:title>
     <dc:description>"이 스크립트를 사용하면 다른 응용 프로그램에서 Adobe Captivate과(와) 통신할 수 있습니다.</dc:description>
</ScriptInfo>
@@@END_XML@@@
*/
//--------------------------------------------------------------------
// CAPTIVATE COMMON INTERFACE
//--------------------------------------------------------------------


var CAP = new Object();
var ca = CAP;	// Also support
var captivateAppName = "captivate";
var bridgeAppName = "bridge";
var captivateVersion = "-9.0"
//---------------------------------------------------------
// quit -  If open, Quit the Captivate application
//

CAP.quit = function ( )
{
	if (BridgeTalk.isRunning(captivateAppName+ captivateVersion)) // First check if Captivate is open 
	{
		CAP.sendScriptToCaptivate( 'CAP.quit();' );
	}
}

//---------------------------------------------------------
// open - Open list of files or sites
//

CAP.open = function ( files )
{
	CAP.sendScriptToCaptivate( 'CAP.openDocument('+CAP.argsToString(arguments)+');');
}

//---------------------------------------------------------
// reveal - If the specified file is open, show it
//

CAP.reveal = function ( file_location ) 
{
	CAP.sendScriptToCaptivate( 'app.reveal('+CAP.argsToString(arguments)+');');
}

//---------------------------------------------------------
// executeScript - Execute the specified script files
//

CAP.executeScript = function ( script_file )
{
	return CAP.sendScriptToCaptivate( 'app.executeScript('+CAP.argsToString(arguments)+');');
}


//--------------------------------------------------------------------
// CAPTIVATE SPECIFIC CODE
//--------------------------------------------------------------------


if( app.name == captivateAppName && (module.name == 'DefaultScript' || module.name == 'Captivate') )
{
    eval( 'BridgeTalk.onReceive = function( obj ) { return eval( obj.body, true ); }', true );
} // End of Captivate specific code



//--------------------------------------------------------------------
// BRIDGE UI
//--------------------------------------------------------------------


//---------------------------------------------------------
// Create Bridge Specific UI
//

if( BridgeTalk.appName == bridgeAppName )
{
	// create main menu object		
	var placeInCaptivateMenu = MenuElement.create( 'command', 
		localize("$$$/extendscript/captivate/PlaceInCaptivate/PlaceInCaptivateSlide=In Captivate"), 
		'at the end of submenu/Place', 'PlaceInAdobeCaptivateStage' );
	
	// open file on stage
	placeInCaptivateMenu.onSelect = function()
	{

		//Get the files, may be remote/version cue
		var sel = app.document.selections;
		app.acquirePhysicalFiles(sel);
		var filesArray = CAP.thumbnailsToFiles(sel);

		if (filesArray != null)
			CAP.place(filesArray, false);
	}
	// open file in document's library
   
	placeInCaptivateMenu.onDisplay = function()
	{
		this.enabled = false;

				this.enabled = true;
	}

} // End of Bridge specific code


//--------------------------------------------------------------------
// UTILITIES
//--------------------------------------------------------------------


//---------------------------------------------------------
// sendScriptToCaptivate - Send script to be evaluated in Captivate
//
// Description:
//

CAP.sendScriptToCaptivate = function( code )
{
	//alert("Sending: '"+code+"'");
	if (app.name == captivateAppName )
	{	// Just execute the code if we are already in Captivate
		return eval(code);
	} else {
		// Create a new BridgeTalk message for Captivate to invoke Quit
		var btMessage = new BridgeTalk;
		btMessage.target = captivateAppName+captivateVersion;
		btMessage.body = code;
		btMessage.onResult = function() {BridgeTalk.bringToFront('captivate-90');}
		btMessage.send();
	}
}


//---------------------------------------------------------
// argsToString -  
//
// Description:
//	This routine create a string for the arguments that we can transmit
//	over BridgeTalk as text.
//
CAP.argsToString = function ( args )
{
	alert("In argsToString");
	var outArgs = new Array();
	
	for( var index=0; index<args.length; index++ )
	{
		outArgs.push(args[index].toSource());
	}
		
	return outArgs.join(',');
}


//---------------------------------------------------------
// thumbnailsToFiles -  
//
// Description:
//	Convert a bridge thumbnails list to file references.
//

CAP.thumbnailsToFiles = function ( thumbList )
{
	var outFileList = new Array();
	var foundAlias = false;
	var	tempStr = new String();
	
	for( var index=0; index<thumbList.length; index++ )
	{
		var file = thumbList[index].spec;
		if (file)
			file = CAP.resolveFileIfAlias(file);
		
		if (thumbList[index].location == "VersionCue"){
			alert("Version Cue not supported by Captivate.");
			return null;
		}
		else
			tempStr = thumbList[index].path;
		//alert(tempStr);
		outFileList.push(tempStr);
	}
		
	return outFileList.join('\n');
	}
//---------------------------------------------------------
// place -  insert files into active document
//
// Description: Place attempts to insert the specified files
//	into the current open documet. If no document is open, it creates
// and opens one
CAP.place = function( fileListIn, placeInLibrary )
{
var fileList = new Array();
var filelistStr="";
var tempStr="";
fileList = fileListIn.split('\n');
if (fileList.length != 0) {
	var script = "if( Captivate.isProjectOpen() == false) { Captivate.createNewProject(800, 600, 'FlashPlayer10_0', true);}";
	var i;
	for (i = 0; i < fileList.length; i++){
		file = fileList[i];
		if (file.length)
		{
			filelistStr = filelistStr + "Captivate.insert (\"" + file +"\"); ";
		}
	}
	//alert(filelistStr);
	script = script + filelistStr ;
	BridgeTalk.bringToFront(captivateAppName);
				//alert("script is:   "+ script);
	CAP.sendScriptToCaptivate(script);
	}
}

//-----------------------------------------------------------------
// If file is an alias: returns file's target if file is
// successfully resolved and the target exists, otherwise null. If
// file is not an alias: returns file.
//-----------------------------------------------------------------

CAP.resolveFileIfAlias = function (file)
	{
	if (file.alias)
		{
		try
			{
			file = file.resolve();
			}
		catch (e)
			{
			file = null;
			}
			
		// On Windows, a shorcut may get resolved even if the target file doesn't exist
		if ((file != null) && !file.exists)
			return null;
		}
	return file;
	}
